<?php
/********************************************************************
 *  C1 Digital – Admin Panel (Loan System)
 *  Author: Siwan Ghafari
 *  Version: Stable v2.0 – Debug Mode enabled
 ********************************************************************/

# ---------------- DEBUG MODE ----------------
error_reporting(E_ALL);
ini_set('display_errors', 1);
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
date_default_timezone_set('Asia/Tehran');

session_start();

# ---------------- DATABASE CONNECTION ----------------
$db_host = "localhost";
$db_user = "c1digico_loansystem";
$db_pass = "mWr2pE}b8hagk=BQ";
$db_name = "c1digico_loansystem";

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
$conn->set_charset("utf8mb4");

# ---------------- ADMIN LOGIN INFO ----------------
$ADMIN_USER = "admin";
$ADMIN_PASS = "c1digital@123";

# ---------------- LOGOUT ----------------
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin_clients.php");
    exit;
}

# ---------------- LOGIN ----------------
if (isset($_POST['login_user'], $_POST['login_pass'])) {
    if ($_POST['login_user'] === $ADMIN_USER && $_POST['login_pass'] === $ADMIN_PASS) {
        $_SESSION['is_admin'] = true;
        header("Location: admin_clients.php");
        exit;
    } else {
        $error = "❌ نام کاربری یا رمز عبور اشتباه است.";
    }
}

# ---------------- AUTH CHECK ----------------
if (!isset($_SESSION['is_admin'])) {
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>ورود مدیر - C1 Digital</title>
<link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;600&display=swap" rel="stylesheet">
<style>
body {
    font-family: 'Vazirmatn', sans-serif;
    background: linear-gradient(135deg,#00bcd4,#00bfa5);
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
}
.login-box {
    background: #fff;
    color: #222;
    padding: 28px;
    width: 300px;
    border-radius: 10px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    text-align: center;
}
input {
    width: 100%;
    padding: 8px;
    margin: 6px 0;
    border: 1px solid #ccc;
    border-radius: 6px;
}
button {
    background: #00bfa5;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
}
button:hover { background: #00bcd4; }
</style>
</head>
<body>
<div class="login-box">
    <h3>🔐 ورود مدیر</h3>
    <?php if (isset($error)) echo "<p style='color:red'>$error</p>"; ?>
    <form method="post">
        <input type="text" name="login_user" placeholder="نام کاربری" required>
        <input type="password" name="login_pass" placeholder="رمز عبور" required>
        <button type="submit">ورود</button>
    </form>
</div>
</body>
</html>
<?php
exit;
}

# ---------------- FILTERING ----------------
$search = $_GET['s'] ?? '';
$date_from = $_GET['from'] ?? '';
$date_to   = $_GET['to'] ?? '';

$where = "1=1";
if ($search) {
    $search = $conn->real_escape_string($search);
    $where .= " AND (phone LIKE '%$search%' OR telegram_id LIKE '%$search%' OR user_ip LIKE '%$search%')";
}
if ($date_from && $date_to) {
    $where .= " AND (DATE(created_at) BETWEEN '$date_from' AND '$date_to')";
}

# ---------------- QUERY MAIN DATA ----------------
$result = $conn->query("SELECT * FROM users_logs WHERE $where ORDER BY created_at DESC");

# ---------------- DASHBOARD STATS ----------------
$total_rows = $conn->query("SELECT COUNT(*) AS cnt FROM users_logs")->fetch_assoc()['cnt'];
$total_users = $conn->query("SELECT COUNT(DISTINCT telegram_id) AS cnt FROM users_logs")->fetch_assoc()['cnt'];
$total_phones = $conn->query("SELECT COUNT(DISTINCT phone) AS cnt FROM users_logs WHERE phone IS NOT NULL AND phone!=''")->fetch_assoc()['cnt'];
$today_count = $conn->query("SELECT COUNT(*) AS cnt FROM users_logs WHERE DATE(created_at)=CURDATE()")->fetch_assoc()['cnt'];

$chart_data = [];
$q = $conn->query("SELECT DATE(created_at) AS d, COUNT(*) AS c FROM users_logs 
                   WHERE created_at >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY DATE(created_at)");
while ($r = $q->fetch_assoc()) $chart_data[] = $r;
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>پنل مدیریتی - C1 Digital</title>
<link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;600&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
body {font-family:'Vazirmatn',sans-serif;background:#f3f8fa;margin:0;}
header {
    background: linear-gradient(135deg,#00bcd4,#00bfa5);
    color:#fff;text-align:right;padding:15px 30px;
}
header a {
    text-decoration:none;color:#fff;
    background:rgba(255,255,255,0.2);padding:5px 10px;border-radius:8px;margin-left:8px;
}
.container{padding:20px;max-width:1200px;margin:auto;}
.stats{display:flex;flex-wrap:wrap;gap:20px;margin-bottom:30px;}
.stat-box{flex:1;min-width:200px;background:#fff;border-radius:10px;padding:20px;text-align:center;box-shadow:0 3px 9px rgba(0,0,0,0.1);}
form{display:flex;flex-wrap:wrap;gap:10px;margin-bottom:20px;align-items:center;}
input,button{padding:8px;border:1px solid #ccc;border-radius:6px;font-family:inherit;}
button{background:#00bfa5;color:#fff;border:none;cursor:pointer;}
button:hover{background:#00bcd4;}
table{width:100%;border-collapse:collapse;}
th,td{padding:8px;border-bottom:1px solid #ddd;font-size:13px;}
th{background:#00bfa5;color:#fff;}
tr:nth-child(even){background:#f9f9f9;}
tr:hover{background:#e0f7fa;}
#chartContainer{background:#fff;border-radius:10px;padding:20px;margin-bottom:25px;}
</style>
</head>
<body>
<header>
  <h2>🔹 داشبورد مدیریت مشتریان C1 Digital</h2>
  <a href="?logout=1">خروج 🚪</a>
</header>

<div class="container">
  <div class="stats">
    <div class="stat-box"><h3><?= $total_rows ?></h3><p>کل لاگ‌ها</p></div>
    <div class="stat-box"><h3><?= $total_users ?></h3><p>کاربران یکتا</p></div>
    <div class="stat-box"><h3><?= $total_phones ?></h3><p>شماره‌های ثبت‌شده</p></div>
    <div class="stat-box"><h3><?= $today_count ?></h3><p>درخواست‌های امروز</p></div>
  </div>

  <div id="chartContainer">
    <canvas id="dailyChart" height="120"></canvas>
  </div>

  <form method="get">
    <input type="text" name="s" value="<?= htmlspecialchars($search) ?>" placeholder="جستجو شماره / IP / آیدی">
    از: <input type="date" name="from" value="<?= htmlspecialchars($date_from) ?>">
    تا: <input type="date" name="to" value="<?= htmlspecialchars($date_to) ?>">
    <button type="submit">🔍 جستجو</button>
  </form>

  <table>
    <tr>
      <th>ID</th><th>Telegram ID</th><th>شماره تلفن</th><th>IP</th><th>پیام</th><th>Callback</th><th>تاریخ</th>
    </tr>
    <?php if ($result->num_rows): while($row=$result->fetch_assoc()): ?>
      <tr>
        <td><?= $row['id'] ?></td>
        <td><?= $row['telegram_id'] ?></td>
        <td><?= $row['phone'] ?></td>
        <td><?= $row['user_ip'] ?></td>
        <td><?= htmlspecialchars($row['message_text']) ?></td>
        <td><?= htmlspecialchars($row['callback_data']) ?></td>
        <td><?= $row['created_at'] ?></td>
      </tr>
    <?php endwhile; else: ?>
      <tr><td colspan="7" style="text-align:center;">⛔ هیچ داده‌ای یافت نشد.</td></tr>
    <?php endif; ?>
  </table>
</div>

<script>
const ctx = document.getElementById('dailyChart');
const chartData = {
    labels:[<?= implode(",", array_map(fn($d)=>"'".$d['d']."'", $chart_data)) ?>],
    datasets:[{
        label:'درخواست‌های ۷ روز اخیر',
        data:[<?= implode(",", array_map(fn($d)=>$d['c'], $chart_data)) ?>],
        backgroundColor:'#00bfa5'
    }]
};
new Chart(ctx,{type:'bar',data:chartData});
</script>
</body>
</html>
<?php $conn->close(); ?>
