<?php
/*
 * Telegram Bot - فروشگاه C1 Digital
 * File: loan.php
 * Description: Bot for installment calculation (۵۰٪ پیش‌پرداخت + ۵٪ سود ماهانه تجمیعی)
 * Author: Siwan Ghafari - C1 Digital (c1digital.ir)
 */

$API_KEY = "8462012374:AAF5BuWHFBXClSbxhWA_-lEaL3iAtlTqeXQ";
define("API_URL", "https://api.telegram.org/bot$API_KEY/");

// دریافت ورودی از تلگرام
$content = file_get_contents("php://input");
$update = json_decode($content, true);

$chat_id = $update["message"]["chat"]["id"] ?? $update["callback_query"]["message"]["chat"]["id"];
$message = $update["message"]["text"] ?? null;
$callback_data = $update["callback_query"]["data"] ?? null;

// --- تابع ارسال پیام
function sendMessage($chat_id, $text, $keyboard = null) {
    $params = [
        "chat_id" => $chat_id,
        "text" => $text,
        "parse_mode" => "HTML",
    ];
    if ($keyboard) {
        $params["reply_markup"] = json_encode(["inline_keyboard" => $keyboard]);
    }
    file_get_contents(API_URL . "sendMessage?" . http_build_query($params));
}

// --- تابع تبدیل عدد فارسی و عربی به انگلیسی ---
function faToEnNumber($string) {
    $persian = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $arabic  = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
    $english = ['0','1','2','3','4','5','6','7','8','9'];
    $string = str_replace($persian, $english, $string);
    $string = str_replace($arabic, $english, $string);
    return $string;
}

// --- مرحله اول: دریافت قیمت نقدی
if ($message) {
    $price_input = faToEnNumber($message); // تبدیل عدد فارسی به انگلیسی برای محاسبه

    if (is_numeric(str_replace(",", "", $price_input))) {
        $price = (float) str_replace(",", "", $price_input);

        $keyboard = [
            [
                ['text' => '1 ماهه', 'callback_data' => "month_1_$price"],
                ['text' => '2 ماهه', 'callback_data' => "month_2_$price"],
                ['text' => '3 ماهه', 'callback_data' => "month_3_$price"],
            ],
            [
                ['text' => '4 ماهه', 'callback_data' => "month_4_$price"],
                ['text' => '5 ماهه', 'callback_data' => "month_5_$price"],
                ['text' => '6 ماهه', 'callback_data' => "month_6_$price"],
            ]
        ];

        sendMessage($chat_id, "📆 لطفاً <b>مدت قسط</b> را انتخاب کنید:", $keyboard);
    } else {
        sendMessage($chat_id, "❗ لطفاً فقط عدد وارد کنید (مثلاً 25000000 یا ۲۵۰۰۰۰۰۰).");
    }
}

// --- مرحله دوم: محاسبه اقساط
elseif ($callback_data && strpos($callback_data, "month_") === 0) {
    $parts = explode("_", $callback_data);
    $months = (int)$parts[1];
    $price = (float)$parts[2];

    // پیش‌پرداخت و مانده
    $prepay = $price / 2;
    $remain = $price / 2;

    // ۵٪ سود در هر ماه، به صورت تجمیعی
    $total_interest_percent = 0.05 * $months;
    $final_remain = $remain * (1 + $total_interest_percent);

    // مبلغ هر قسط و مجموع نهایی پرداختی
    $monthly_payment = $final_remain / $months;
    $total_payment = $prepay + $final_remain;

    // پیام خروجی برای کاربر
    $text = "🧮 <b>محاسبه اقساط فروشگاه C1 Digital</b>\n\n" .
        "💰 قیمت نقدی: " . number_format($price) . " تومان\n" .
        "💵 پیش‌پرداخت (۵۰٪): " . number_format($prepay) . " تومان\n" .
        "📦 مانده: " . number_format($remain) . " تومان\n" .
        "📆 مدت اقساط: $months ماه\n" .
        "📈 سود کل (${months}×۵٪): " . ($total_interest_percent * 100) . "%\n\n" .
        "💸 مانده با سود: " . number_format($final_remain) . " تومان\n" .
        "💳 مبلغ هر قسط: " . number_format($monthly_payment) . " تومان\n" .
        "🔹 مجموع کل پرداختی: " . number_format($total_payment) . " تومان\n\n" .
        "📅 <b>برنامه پرداخت:</b>\n";

    // جدول اقساط ماهانه
    for ($i = 1; $i <= $months; $i++) {
        $text .= "🟩 ماه $i: " . number_format($monthly_payment) . " تومان\n";
    }

    sendMessage($chat_id, $text);
}

// --- پیام اولیه برای کاربر جدید
else {
    sendMessage($chat_id, "سلام 👋 <b>به ربات محاسبه اقساط فروشگاه C1 Digital خوش آمدید.</b>\n\nلطفاً قیمت نقدی دستگاه را وارد کنید (مثلاً 30000000 یا ۳۰۰۰۰۰۰۰).");
}
?>
