<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('Asia/Tehran');

// تبدیل عدد فارسی به انگلیسی
function faToEnNumber($n){
  return str_replace(['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'], ['0','1','2','3','4','5','6','7','8','9'], $n);
}

if($_SERVER['REQUEST_METHOD']==='POST'){
  $price = faToEnNumber($_POST['price']);
  $months = faToEnNumber($_POST['months']);
  if(!is_numeric($price) || !is_numeric($months) || $months < 1){
    echo "<script>alert('ورودی نامعتبر است');</script>"; exit;
  }

  // محاسبه اقساط
  $prepay = $price * 0.5;
  $remain = $price - $prepay;
  $interestRate = 0.05 * $months;
  $total = $remain * (1 + $interestRate);
  $install = $total / $months;

  // خروجی فیش
  echo "
  <div class='receipt-container'>
    <div class='receipt'>
      <h2>🧾 فیش محاسبه اقساط</h2>
      <p><strong>قیمت کالا:</strong> ".number_format($price)." تومان</p>
      <p><strong>پیش‌پرداخت (۵۰٪):</strong> ".number_format($prepay)." تومان</p>
      <p><strong>مدت اقساط:</strong> {$months} ماه</p>
      <p><strong>درصد سود کل:</strong> ".($interestRate*100)."٪</p>
      <hr>
      <table>
        <tr><th>ماه</th><th>قسط ماهانه</th></tr>";
        for($i=1;$i<=$months;$i++){
          echo "<tr><td>{$i}</td><td>".number_format($install)." تومان</td></tr>";
        }
  echo "</table>
      <hr>
      <p class='footer'>💎 طراحی و توسعه C1 Digital</p>
    </div>
  </div>

  <style>
  body{
    font-family:'Vazirmatn','IRANSans';
    background:linear-gradient(135deg,#009688,#4CAF50);
    margin:0;padding:0;direction:rtl;
  }
  .receipt{
    background:#fff;border-radius:18px;padding:35px;width:90%;
    max-width:600px;box-shadow:0 6px 25px rgba(0,0,0,0.15);
    animation:fadein .5s ease-out;
  }
  h2{color:#009688;text-align:center;font-size:22px;margin-bottom:25px;}
  p{font-size:17px;margin:6px 0;}
  table{width:100%;border-collapse:collapse;margin-top:15px;}
  th,td{text-align:center;padding:12px;border-bottom:1px solid #eee;}
  th{background:#009688;color:#fff;}
  .footer{text-align:center;color:#777;font-size:13px;margin-top:20px;}
  @keyframes fadein{from{opacity:0;transform:translateY(15px);}to{opacity:1;transform:translateY(0);} }
  @media(max-width:600px){
    .receipt-container{display:flex;justify-content:center;align-items:center;width:100vw;height:100vh;padding:0;}
    .receipt{border-radius:0;box-shadow:none;width:100%;height:100vh;max-width:none;padding:60px 25px 80px;overflow:auto;}
    h2{font-size:26px;}p,th,td{font-size:18px;}th{padding:14px;}
  }
  </style>";
  exit;
}
?>

<!DOCTYPE html>
<html lang='fa'>
<head>
<meta charset='UTF-8'>
<meta name='viewport' content='width=device-width, initial-scale=1'>
<title>محاسبه اقساط C1 Digital</title>
<link href='https://fonts.googleapis.com/css2?family=Vazirmatn&display=swap' rel='stylesheet'>
<style>
body{
  font-family:'Vazirmatn','IRANSans';
  background:linear-gradient(135deg,#009688,#4CAF50);
  margin:0;padding:0;direction:rtl;
}
.container{
  display:flex;align-items:center;justify-content:center;
  min-height:100vh;padding:20px;
}
form{
  background:#fff;border-radius:18px;
  box-shadow:0 6px 25px rgba(0,0,0,0.15);
  padding:40px 35px;width:100%;max-width:600px;
  animation:fadein .5s ease-out;
}
h2{color:#009688;text-align:center;font-size:26px;margin-bottom:25px;}
input,select{
  width:100%;padding:17px;margin:12px 0;
  border:none;border-radius:12px;background:#f5f5f5;
  text-align:center;font-size:18px;box-sizing:border-box;
}
button{
  background:#009688;color:#fff;border:none;padding:18px;width:100%;
  border-radius:12px;font-size:18px;font-weight:bold;cursor:pointer;
  transition:.3s background;
}
button:hover{background:#00796B;}
@keyframes fadein{from{opacity:0;transform:translateY(15px);}to{opacity:1;transform:translateY(0);} }
@media(max-width:600px){
  form{border-radius:0;box-shadow:none;height:100vh;max-width:none;padding:50px 25px;}
  input,select,button,h2{font-size:19px;padding:20px;}
}
</style>
</head>

<body>
<div class='container'>
<form method='POST'>
  <h2>C1 Digital محاسبه‌گر اقساط</h2>
  <input type='text' name='price' placeholder='مبلغ کالا (تومان)' required>
  <select name='months' required>
    <option value=''>مدت اقساط</option>
    <option value='1'>۱ ماهه</option>
    <option value='2'>۲ ماهه</option>
    <option value='3'>۳ ماهه</option>
    <option value='4'>۴ ماهه</option>
    <option value='5'>۵ ماهه</option>
    <option value='6'>۶ ماهه</option>
  </select>
  <button type='submit'>محاسبه</button>
</form>
</div>
</body>
</html>
