<?php
//------------------------------------------------------
// Ganji | C1 Digital – Telegram Relay (Only)
//------------------------------------------------------

date_default_timezone_set('Asia/Tehran');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// تنظیمات عمومی
$botToken    = "8220037711:AAEaHJf_OAE8TL_uLgN5ZtxM6DViVf4VnJE"; // توکن تلگرام مدیر
$chatId      = "76865084";                                       // Chat ID مدیر
$secureKey   = "SECURE_KEY_123";                                 // کلید امنیتی
$baseApiHost = "https://check.c1laptop.com/api";                 // هاست اصلی دیتابیس و API

//------------------------------------------------------
// 🔹 بخش اول: دریافت چک‌های سررسید امروز از هاست اصلی
//------------------------------------------------------
$apiUrl = $baseApiHost . "/checks_due.php?token=" . $secureKey;
$response = @file_get_contents($apiUrl);
if (!$response) {
    die("⛔ خطا در دریافت اطلاعات از API هاست مرکزی.\n");
}

$data = json_decode($response, true);
if (!is_array($data)) {
    die("⚠️ پاسخ API معتبر نیست.\n");
}

if (count($data) === 0) {
    echo "✅ هیچ چک موعد امروز یافت نشد.\n";
    exit;
}

//------------------------------------------------------
// 🔹 ارسال اعلان تلگرام برای هر چک موعد امروز
//------------------------------------------------------
foreach ($data as $check) {
    $customer = $check['customer_name'] ?: 'نامشخص';
    $serial   = $check['serial_number'];
    $amount   = number_format($check['amount']);
    $dueJal   = $check['due_date_jalali'];

    $msg = "📅 <b>یادآوری چک سررسید امروز</b>\n"
         . "👤 <b>مشتری:</b> {$customer}\n"
         . "💰 <b>مبلغ:</b> {$amount} تومان\n"
         . "🔢 <b>شماره صیادی:</b> {$serial}\n"
         . "🗓 <b>تاریخ موعد:</b> {$dueJal}\n\n"
         . "🕒 ارسال خودکار از <b>C1Laptop</b> → <b>C1Notify</b>";

    // ارسال به تلگرام
    $sendUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";
    $payload = [
        'chat_id' => $chatId,
        'text'    => $msg,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($sendUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    $resp = curl_exec($ch);
    curl_close($ch);

    //------------------------------------------------------
    // 🔸 بروزرسانی اعلان در هاست مرکزی
    //------------------------------------------------------
    $updateUrl = $baseApiHost . "/update_notify.php";
    $ch2 = curl_init($updateUrl);
    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch2, CURLOPT_POST, true);
    curl_setopt($ch2, CURLOPT_POSTFIELDS, [
        'token' => $secureKey,
        'id'    => $check['id'],
        'type'  => 'telegram',
        'log'   => $resp
    ]);
    curl_exec($ch2);
    curl_close($ch2);

    sleep(1); // تاخیر کوچک برای جلوگیری از اسپم تلگرام
}

echo "🎯 اعلان تلگرام برای مدیریت ارسال شد (" . count($data) . " رکورد)\n";
?>
