<?php
/**
 * ----------------------------------------------------
 * Sivan Digital - Telegram Relay (send.php)
 * Host: noti.c1digi.com
 * Purpose: دریافت پیام و PDF از هاست اصلی
 *          و ارسال به تلگرام با cURL مطمئن
 * Dev: Ganji | 2025-10-22
 * ----------------------------------------------------
 */

// ============================
// تنظیمات اولیه
// ============================
date_default_timezone_set('Asia/Tehran');
header('Content-Type: application/json; charset=utf-8');

// مسیر لاگ
$logFile = __DIR__ . '/relay_log.txt';
if (!file_exists($logFile)) {
    touch($logFile);
    chmod($logFile, 0666);
}

// ============================
// اطلاعات ربات و مدیر
// ============================
$botToken = '8220037711:AAEaHJf_OAE8TL_uLgN5ZtxM6DViVf4VnJE';
$chat_id  = '76865084';


// ============================
// دریافت داده از درخواست POST
// ============================
$text = trim($_POST['text'] ?? '');
$pdf  = trim($_POST['pdf'] ?? '');

$client_ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$now = date('Y-m-d H:i:s');

// لاگ ورودی
file_put_contents($logFile,
    "$now | ---- New Request from {$client_ip} ----\n" .
    "Text: {$text}\n" .
    "PDF: {$pdf}\n",
FILE_APPEND);


// ============================
// اعتبارسنجی ورودی
// ============================
if ($text === '' && $pdf === '') {
    file_put_contents($logFile, "⚠️ Empty POST received.\n-------------------------\n", FILE_APPEND);
    echo json_encode(['status'=>'error','message'=>'No data received.']);
    exit;
}


// ============================
// ارسال پیام متنی
// ============================
$telegram_url_msg = "https://api.telegram.org/bot{$botToken}/sendMessage";

$post_msg = [
    'chat_id'    => $chat_id,
    'text'       => $text,
    'parse_mode' => 'HTML'
];

$ch_msg = curl_init($telegram_url_msg);
curl_setopt_array($ch_msg, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_HTTPHEADER     => ['Content-Type: multipart/form-data; charset=utf-8'],
    CURLOPT_POSTFIELDS     => $post_msg,
    CURLOPT_TIMEOUT        => 15
]);
$response_text = curl_exec($ch_msg);
$error_text = curl_error($ch_msg);
curl_close($ch_msg);


// ============================
// ارسال فایل PDF (با URL)
// ============================
$response_file = '';
$error_file = '';

if ($pdf !== '') {
    $telegram_url_file = "https://api.telegram.org/bot{$botToken}/sendDocument";

    $post_file = [
        'chat_id' => $chat_id,
        'document' => $pdf,      // چون URL است، مستقیماً ارسال می‌شود
        'caption' => $text
    ];

    $ch_file = curl_init($telegram_url_file);
    curl_setopt_array($ch_file, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => ['Content-Type: multipart/form-data; charset=utf-8'],
        CURLOPT_POSTFIELDS     => $post_file,
        CURLOPT_TIMEOUT        => 20
    ]);
    $response_file = curl_exec($ch_file);
    $error_file = curl_error($ch_file);
    curl_close($ch_file);
}


// ============================
// ذخیره در لاگ
// ============================
file_put_contents($logFile,
    "Response_Text: {$response_text}\n" .
    "Response_File: {$response_file}\n" .
    "Error_Text: {$error_text}\n" .
    "Error_File: {$error_file}\n" .
    "--------------------------\n",
FILE_APPEND);


// ============================
// خروجی نهایی
// ============================
echo json_encode([
    'status'           => 'ok',
    'message'          => 'Notification sent to Telegram',
    'telegram_response'=> json_decode($response_text, true),
    'telegram_file'    => json_decode($response_file, true),
    'error_text'       => $error_text,
    'error_file'       => $error_file
], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
exit;
?>
